# 연산자
산술 연산자: `+, -, *, /, //, %, **`
비교 연산자: `==, !=, <=, >=, <, >`
불리언 연산자: `not, and, or`

참고: 게임의 모든 숫자는 부동 소수점 숫자예요. 따라서 모든 산술 연산자는 부동 소수점 연산자예요.
`//`는 나눗셈 후 숫자를 내림하는 것으로 정의돼요.

할당 연산자를 사용하려면 "변수" 해금이 필요해요.

## 소개
연산자를 사용하면 값을 비교, 수정, 결합할 수 있어요.
산술 연산자 `+, -, *, /, //, %, **`는 숫자에 대한 일반적인 수학 연산을 수행하는 데 사용돼요.
비교 연산자 `==, !=, <=, >=, <, >`는 값을 비교하는 데 사용돼요. 결과는 항상 `True` 또는 `False`예요.
논리 연산자 (불리언 연산자라고도 함) `not, and, or`는 진리값을 결합하는 데 사용돼요.

## 산술 연산자
`+`와 `-`는 덧셈과 뺄셈에 사용돼요.

`2 + 3`은 `5`로 평가돼요
`3 - 2`는 `1`로 평가돼요

`*`, `/`, `//`는 곱셈과 나눗셈에 사용돼요.

`2 * 3`은 `6`으로 평가돼요
`5 / 2`는 `2.5`로 평가돼요

`//`는 `/`와 같은 일을 하지만 결과는 내림돼요 (다음 정수로 버림).

`5 // 2`는 `2`로 평가돼요

`%`는 모듈로 연산자이며, 나머지 연산자라고도 알려져 있어요. 기본적으로 두 숫자를 나누고 나머지를 반환해요. 오른쪽 숫자를 왼쪽 숫자에서 나머지가 오른쪽 숫자보다 작아질 때까지 반복적으로 빼는 것으로 생각할 수도 있어요.

`4 % 2`는 `0`으로 평가돼요
`5 % 2`는 `1`로 평가돼요
`6 % 2`는 `0`으로 평가돼요
`2 % 6`은 `2`로 평가돼요
`1.5 % 1`은 `0.5`로 평가돼요

`**`는 거듭제곱 연산자예요.

`2**2`는 `4`로 평가돼요
`(-5)**3`은 `-125`로 평가돼요

## 비교 연산자
`==`와 `!=`는 두 값이 "같음"(`==`) 또는 "같지 않음"(`!=`)인지 확인하는 데 사용돼요. 모든 유형의 값에 사용할 수 있어요.

`2 == 2`는 `True`로 평가돼요
`Entities.Bush != Entities.Bush`는 `False`로 평가돼요
`3 != 3 + 1`은 `True`로 평가돼요

`<=, >=, <, >`는 숫자에만 사용할 수 있어요. 왼쪽 숫자가 오른쪽 숫자보다 "작거나 같음"(`<=`), "크거나 같음"(`>=`), "작음" (`<`) 또는 "큼" (`>`)인지 확인해요.

`1 <= 1`은 `True`로 평가돼요
`2 >= 3`은 `False`로 평가돼요
`-2 < -1`은 `True`로 평가돼요
`6 > 6`은 `False`로 평가돼요

## 논리 연산자
`not`은 단순히 값을 반전시켜요:

`not False`는 `True`로 평가돼요
`not True`는 `False`로 평가돼요

`and`는 두 값이 모두 `True`일 경우에만 `True`로 평가돼요

`True and True`는 `True`로 평가돼요
`True and False`는 `False`로 평가돼요
`False and False`는 `False`로 평가돼요

`or`는 값 중 하나 이상이 `True`이면 `True`로 평가돼요

`True or True`는 `True`로 평가돼요
`True or False`는 `True`로 평가돼요
`False or False`는 `False`로 평가돼요